/*
 * Copyright (C) 2012 Edge-Core Networks
 * This software file (the "File") is owned and distributed by 
 * Edge-Core Networks under the following licensing terms.
 * 
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of
 * the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston,
 * MA 02111-1307 USA
 */

#ifndef _AMS_COMMON_H_
#define _AMS_COMMON_H_

#include "ams_lib.h"

#define FALSE 0
#define TRUE  1

typedef int BOOL;

#define AMS_DEBUG

#ifdef AMS_DEBUG

#define AMS_HALT()          \
    do {                    \
        for (;;);           \
    } while(0);

#define AMS_ASSERT(cond, msg)                  \
    do {                                       \
        if (cond)                              \
        {                                      \
            ams_printk("<4>line %d of file %s:%s", \
                __LINE__, __FILE__, msg);      \
            AMS_HALT();                        \
        }                                      \
    } while(0);

#define AMS_PRINTK ams_printk

#else

#define AMS_ASSERT(cond, msg) 
#define AMS_PRINTK 

#endif

#define RC_PARAMENT_ERROR       -2
#define RC_ERROR                -1
#define RC_OK                    0
#define RC_PART_CHECK_ERROR	     1
#define RC_PART_NUMBER_EXCEED    2
#define RC_PART_DO_NOT_EXIST     3

/* special pattern for doing special boot for factory-default runtime recovery. */
#define FS_HW_INFO_SPECIAL_BOOT_OP_RECOVERY_STAGE1 0xed9ec01e
#define FS_HW_INFO_SPECIAL_BOOT_OP_RECOVERY_STAGE2 0xed9ec02e

/*
 *  Hardware Information type
 */
#define SYS_ADPT_MAC_ADDR_LEN                           6
#define SYS_ADPT_SERIAL_NO_STR_LEN                      21  /* max 21 chars, example: ACTyywwnnnn */
#define SYS_ADPT_HW_VER_STR_LEN                         5   /* max 5 chars, example: R01A         */
#define SYS_ADPT_MANUFACTURE_DATE_LEN                   10  /* eg. 2001-11-09                     */
#define SYS_ADPT_RESERVED_INFO_LEN                      32
#define SYS_ADPT_MODEL_NUMBER_LEN                       15  /* max 15 chars, example: ES3508A-B3  */
#define SYS_ADPT_MAX_OEM_PASSWORD_LEN                   32  /* 2009/08/27, aaron revised from 8 in order to make sync with Runtime */
#define SYS_ADPT_FILE_SYSTEM_NAME_LEN                   32

#define SYS_ADPT_FW_VER_STR_LEN                     11  /* max 11 chars, example: 1.02.23.01  */
#define SYS_ADPT_LOADER_CUSTOMIZED_VER_STR_LEN      SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_POST_CUSTOMIZED_VER_STR_LEN        SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_FW_CUSTOMIZED_VER_STR_LEN          SYS_ADPT_FW_VER_STR_LEN
#define SYS_ADPT_KERNEL_VER_STR_LEN                 19  /* max 19 chars, example: 2.6.19.2-1-1.1 */

/* WARNING!!! this is a duplicated definition of FS_HW_Info_T
 * The definition must be exactly the same with the one defined in
 * fs.h
 */
typedef struct FS_HW_Info_S
{
    unsigned char   mac_addr[SYS_ADPT_MAC_ADDR_LEN];                    /* MAC address */
    unsigned char   serial_no[SYS_ADPT_SERIAL_NO_STR_LEN + 1];          /* serial number */
    unsigned char   agent_hw_ver[SYS_ADPT_HW_VER_STR_LEN + 1];          /* agent board hardware version (len 5+1) */
    unsigned char   manufacture_date[SYS_ADPT_MANUFACTURE_DATE_LEN];    /* Product date, option to key in */
    unsigned long   model_num;                                          /* Model number */
    unsigned long   mode_bitmap1;                                       /* Mode bitmap */
    unsigned long   mode_bitmap2;                                       /* Mode bitmap */
    unsigned long   mode_bitmap3;                                       /* Mode bitmap */
    unsigned long   mode_bitmap4;                                       /* Mode bitmap */
    unsigned char   service_tag[SYS_ADPT_SERIAL_NO_STR_LEN +1];         /* Service tag */
    unsigned long   project_id;                                         /* Project ID  */
    unsigned long   board_id;                                           /* Board ID    */
    unsigned char   password[SYS_ADPT_MAX_OEM_PASSWORD_LEN + 1];        /* OEM password */
    unsigned long   baudrate;                                           /* Filled by loader information */
    unsigned char   model_num_by_string[SYS_ADPT_MODEL_NUMBER_LEN + 1]; /* For model number in character string. */
    unsigned char   post_mode;                                          /* POST_ITEM_INDEX_T defined in post_list.h */
    unsigned long   special_boot_op;                                    /* special boot option, for nand flash factory-defualt runtime recovery */
    unsigned char   reserved2[SYS_ADPT_RESERVED_INFO_LEN + (SYS_ADPT_RESERVED_INFO_LEN - 21 - SYS_ADPT_MODEL_NUMBER_LEN - 1 - 1/*post_mode*/ - 4 /*special_boot_op*/)]; /* reserved for more board info */
    unsigned char   reserved3[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned char   reserved4[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned char   reserved5[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned char   reserved6[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned char   reserved7[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned char   reserved8[SYS_ADPT_RESERVED_INFO_LEN];              /* reserved for more board info */
    unsigned short  check_sum;                                          /* check sum */
}__attribute__((packed, aligned(1))) FS_HW_Info_T;



#define BOOL_T       unsigned char
#define SYS_ADPT_FS_FILEMAPPING_FILENAME        ".fmapping"
#define FS_FOLDER                               ".fs/"

/* The definition must be exactly the same with the one defined in
 * runtime: src\user\driver\fs\include\fs_type.h
 */
/* FS_File_Type_T is used by runtime and loader
 * It is known that some compiler option might effect the
 * data type of enum. To avoid inconsistent data type definition
 * between runtime and loader, it is better to define FS_File_Type_T as unsigned long explicitly
 */
typedef unsigned long FS_File_Type_T;
/*typedef*/ enum FS_File_Type_E
{
    FS_FILE_TYPE_SUBFILE    = 0,
    FS_FILE_TYPE_KERNEL,
    FS_FILE_TYPE_DIAG,
    FS_FILE_TYPE_RUNTIME,
    FS_FILE_TYPE_SYSLOG,
    FS_FILE_TYPE_CMDLOG,
    FS_FILE_TYPE_CONFIG,
    FS_FILE_TYPE_POSTLOG,
    FS_FILE_TYPE_PRIVATE,
    FS_FILE_TYPE_CERTIFICATE,
    FS_FILE_TYPE_ARCHIVE,
    FS_FILE_TYPE_BINARY_CONFIG,
    FS_FILE_TYPE_PUBLIC,
    FS_FILE_TYPE_CPEFIRMWARE,
    FS_FILE_TYPE_CPECONFIG,
    FS_FILE_TYPE_FILEMAPPING,
    FS_FILE_TYPE_TOTAL      /* Number of total file type */
} /*FS_File_Type_T*/;

/*
 *  FileMapping File Management
 */
#define FS_FILEMAPPING_RUNTIME_NUM   2
#define FS_FILEMAPPING_CFG_NUM       1
#define FS_FILEMAPPING_TOTAL_NUM         (FS_FILEMAPPING_RUNTIME_NUM+FS_FILEMAPPING_CFG_NUM) /*two runtime and on startup cfg*/

typedef struct {                  
    unsigned char file_name[SYS_ADPT_FILE_SYSTEM_NAME_LEN]; /* filename */
    unsigned long file_size;                    /* file size */
    unsigned long creat_time;                   /* file create time */
    FS_File_Type_T file_type;                    /* file type */
    BOOL_T  startup_flag;                  /* start-up flag  indicate status is active or free */              
}FS_FILEMAPPING_FILE_DATA_T;


typedef struct {    
    FS_FILEMAPPING_FILE_DATA_T   file_data[FS_FILEMAPPING_TOTAL_NUM];
}FS_FILEMAPPING_FILE_T;

#endif

